% script for making the calibration curve and curve fitting

clear all, close all

% read calibration data
data = xlsread('calibrationcurve_averagedata_matlab.xlsx');
c_in = data(:,1);
Z = data(:,2:end);
no_curves = size(Z,2);
c = repmat(c_in,1,no_curves);

% read measurement data
data_flow = xlsread('calibrationcurve_averagedata_matlab.xlsx','flowrate');
Z_flow = data_flow(:,2:end);
Z_flow = flipud(Z_flow); % to put the channels in the right order: D-C-D-C-D-C

data_current = xlsread('calibrationcurve_averagedata_matlab.xlsx','current_chip16');
Z_current = data_current(:,2:end);

%% curve fitting

% data into one column vector for fitting
c = c(:);
Z = Z(:);

% logarithmic fit
c_in_log = log10(c_in);
c_log = log10(c);
I_log = log10(Z);

exclude1 = c < 0.05;
exclude2 = c_log < log10(0.05);

% fit data
[f,gof,output] = fit(c,Z,'power1','Exclude',exclude1);
[f_log,gof_log,output_log] = fit(c_log,I_log,'poly1','Exclude',exclude2);

% get 95% confidence intervals for power law fit
ci_f = confint(f,0.95); % confidence intervals for predictor functions
pb_f = predint(f,c_in,0.95); % prediction intervals for observation functions
pb_fl = pb_f(:,1); % lower bound
pb_fu = pb_f(:,2); % upper bound

% get 95% confidence intervals for linear fit
coeff_log = coeffvalues(f_log);
ci_f_log = confint(f_log,0.95);
pb_f_log = predint(f_log,c_in_log,0.95);
pb_fl_log = pb_f_log(:,1);
pb_fu_log = pb_f_log(:,2);

%% plot curve fitting data

% plot data
nn = 0;

% nn = nn + 1;
% figure(nn)
% hold on
% plot(f,c,I,'predobs')
% plot(c_in,ci_f(1,1).*c_in.^(ci_f(1,2)),'-ok')
% plot(c_in,ci_f(2,1).*c_in.^(ci_f(2,2)),'-ok')
% plot(c_in,pb_fu,'--bs')
% plot(c_in,pb_fl,'--bs')
% set(gca,'XScale','log');
% %set(gca,'YScale','log');
% 
% nn = nn + 1;
% figure(nn)
% plot(f, c, I, exclude1, 'residuals' );
% set(gca,'XScale','log');
% %ylim([-5000 5000]);
% 
% nn = nn + 1;
% figure(nn)
% normplot(output.residuals);

nn = nn + 1;
figure(nn)
hold on
plot(f_log,c_log,I_log,exclude2,'predobs')
%plot(c_in_log,pb_fu_log,'--bs') % check whether function for prediction
%bounds is correct
%plot(c_in_log,pb_fl_log,'--bs') % check whether function for prediction
%bounds is correct
hold off
box on
legend boxoff
xlabel('log_{10}(c) (mM)')
ylabel('log_{10}(Z) (\Omega)')
xlim([-2.05 1.05])
text(-1.5,2.75,['log_{10}(Z) = ' num2str(coeff_log(1)) ' log_{10}(c) + ' num2str(coeff_log(2))]);
set(gcf,'color','w');
fig = gcf;
%set(findall(fig,'-property','FontSize'),'FontSize',13) 
%export_fig calibrationcurve.png -m3
%matlab2tikz('calibrationcurve.tikz', 'height', '\figureheight', 'width', '\figurewidth');

nn = nn + 1;
figure(nn)
plot(f_log,c_log,I_log,exclude2,'residuals' );

nn = nn + 1;
figure(nn)
normplot(output_log.residuals);

%% compute measured concentrations

% get the 95% reliability for a measured impedance Z
% Z_test = 1e4;
% log_Z_test = log10(Z_test);
% log_cout = (log_Z_test - coeff_log(2))./coeff_log(1)
% cout = 10.^log_cout
% log_cout_l = interp1(pb_fl_log,c_in_log,log_Z_test,'spline')
% cout_l = 10.^log_cout_l
% log_cout_u = interp1(pb_fu_log,c_in_log,log_Z_test,'spline')
% cout_u = 10.^log_cout_u

% get the 95% prediction interval for a measured impedance Z
% log(Z) = coeff(1)*log(c) + coeff(2)
log_Z_flow = log10(Z_flow);
log_c_flow = (log_Z_flow - coeff_log(2))./coeff_log(1);
c_flow = 10.^log_c_flow;
log_c_flow_l = interp1(pb_fl_log,c_in_log,log_Z_flow,'spline');
c_flow_l = 10.^log_c_flow_l;
log_c_flow_u = interp1(pb_fu_log,c_in_log,log_Z_flow,'spline');
c_flow_u = 10.^log_c_flow_u;

predbands_flow(:,:,1) = c_flow - c_flow_l;
predbands_flow(:,:,2) = c_flow_u - c_flow;

% get the 95% prediction interval for a measured impedance Z
log_Z_current = log10(Z_current);
log_c_current = (log_Z_current - coeff_log(2))./coeff_log(1);
c_current = 10.^log_c_current;
log_c_current_l = interp1(pb_fl_log,c_in_log,log_Z_current,'spline');
c_current_l = 10.^log_c_current_l;
log_c_current_u = interp1(pb_fu_log,c_in_log,log_Z_current,'spline');
c_current_u = 10.^log_c_current_u;

predbands_current(:,:,1) = c_current - c_current_l;
predbands_current(:,:,2) = c_current_u - c_current;

%% plot concentration histograms

% colors
no_exp = size(c_current,2);
map = cbrewer('seq','OrRdBlGr',no_exp);

% concentration histogram for fixed potential difference
nn = nn + 1;
figure(nn)
hold on
h = plot([0.5 6.5],[1 1],':k');
[b berror] = barwitherr(predbands_flow,c_flow);
%b = bar(c_flow);
hold off
box on
xlim([1.35 5.65])
ylim([0 2])
for j = 1:size(c_flow,2)
    set(b(j),'FaceColor',map(j,:));
end
set(get(get(h,'Annotation'),'LegendInformation'),'IconDisplayStyle','off');
set(get(get(berror(1),'Annotation'),'LegendInformation'),'IconDisplayStyle','off');
set(get(get(berror(2),'Annotation'),'LegendInformation'),'IconDisplayStyle','off');
legend(b(1:size(c_flow,2)),{'3 \muL min^{-1}','5 \muL min^{-1}'})
%legend('Location','NorthWest')
legend boxoff
title('(a) Outlet concentrations at   \DeltaU = 70V for 1 mM NaCl')
%title('(b) Outlet concentrations at 3 \muL min^{-1} for 1 mM NaCl')
set(gca,'XTick',[1:6])
xlabel('channel number')
ylabel('c (mM)')
set(gcf,'color','w');
set(findall(gcf,'-property','FontSize'),'FontSize',13) 
%print('BarPlot','-dpng','-r300')
export_fig cNaCl_flow_revised.png -m3 -nocrop
%matlab2tikz('cNaCl_flow.tikz', 'height', '\figureheight', 'width', '\figurewidth');

% concentration histogram for fixed flow rate
nn = nn + 1;
figure(nn)
hold on
h = plot([0.5 6.5],[1 1],':k');
b = barwitherr(predbands_current,c_current);
hold off
box on
xlim([1.35 5.65])
ylim([0 2])
for j = 1:size(c_current,2)
    set(b(j),'FaceColor',map(j,:));
end
set(get(get(h,'Annotation'),'LegendInformation'),'IconDisplayStyle','off');
set(get(get(berror(1),'Annotation'),'LegendInformation'),'IconDisplayStyle','off');
set(get(get(berror(2),'Annotation'),'LegendInformation'),'IconDisplayStyle','off');
%legend('3 \muA','5 \muA','7 \muA')
legend('12.2 A m^{-2}','20.3 A m^{-2}','28.4 A m^{-2}')
%legend('Location','NorthWest')
legend boxoff
title('(b) Outlet concentrations at 3   \muL min^{-1} for 1 mM NaCl')
set(gca,'XTick',[1:6])
xlabel('channel number')
ylabel('c (mM)')
set(gcf,'color','w');
set(findall(gcf,'-property','FontSize'),'FontSize',13) 
%print('BarPlot','-dpng','-r300')
export_fig cNaCl_current_revised.png -m3 -nocrop
%matlab2tikz('cNaCl_current.tikz', 'height', '\figureheight', 'width', '\figurewidth');



